<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodleorg', language 'es', branch 'MOODLE_23_STABLE'
 *
 * @package   local_moodleorg
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutdemosite'] = 'Nuestro sitio de demostración es un sitio Moodle con todas sus características y algunos cursos de ejemplo donde puede acceder como profesor, estudiante o incluso como administrador. No se preocupe por estropear algo, el sitio al completo se vacía y reinicia cada hora.';
$string['aboutdemositetitle'] = 'Sitio de demostración';
$string['aboutintro'] = 'Moodle es un Sistema de Gestión de Cursos de Código Abierto (<i>Open Source Course Management System, CMS</i>), conocido también como Sistema de Gestión del Aprendizaje (<i>Learning Management System, LMS</i>) o como Entorno de Aprendizaje Virtual (<i>Virtual Learning Environment, VLE</i>).  Es muy popular entre los educadores de todo el mundo como una herramienta para crear sitios web dinámicos en línea para sus estudiantes. Para utilizarlo, necesita ser instalado en un servidor web, puede ser instalado tanto en un ordenador personal como en un servidor proporcionado por una compañía de hospedaje de páginas web.';
$string['aboutoverview'] = '<p>El objetivo del proyecto Moodle es siempre facilitar a los educadores las mejores herramientas para gestionar y promover el aprendizaje, pero hay muchas formas de utilizar Moodle:</p>
<ul>
<li>Moodle dispone de características que le permiten escalar a grandes despliegues con cientos de miles de estudiantes, pero también puede ser utilizado en escuelas de educación infantil y primaria.</li>
<li>Muchas instituciones lo utilizan como su plataforma para formación en línea mientras que otras lo utilizan como apoyo a la formación presencial (conocida como blended learning en inglés).</li>
<li>A muchos de nuestros usuarios les encanta utilizar los módulos de actividad (como los foros, bases de datos o wikis) para construir ricas comunidades colaborativas de aprendizaje alrededor de una materia (en la tradición del constructivismo social), mientras que otros prefieren utilizar Moodle como una forma de ofrecer contenidos a sus estudiantes (utilizando por ejemplo paquetes SCORM) y realizar evaluaciones utilizando tareas o cuestionarios.</li>
</ul>';
$string['aboutoverviewtitle'] = '¿Qué es Moodle?';
$string['aboutstatistics'] = 'Moodle se puede descargar libremente y su registro es voluntario, de manera de que no disponemos de información al completo de quién lo está utilizando. De todas formas, con la información de que disponemos, generamos automáticamente algunas gráficas y datos numéricos en nuestra página de Estadísticas.';
$string['aboutstatisticsheading'] = 'Estadísticas de Moodle';
$string['aboutstatisticstitle'] = 'Moodle.org: Estadísticas de Moodle';
$string['activeusers24hours'] = 'Usuarios registrados que han accedido en las últimas 24 horas:';
$string['activeuserspastmonth'] = 'Usuarios registrados que han accedido en el último mes:';
$string['browsecvstitle'] = 'Navegue por nuestro código fuente';
$string['communityintro'] = 'Moodle tiene una gran y diversa comunidad de usuarios con alrededor de <a href="http://moodle.org/userpics">{$a->usercount} usuarios registrados</a> sólamente en este sitio Moodle, hablando más <a href="http://download.moodle.org/lang16/">{$a->langcount} idiomas</a> en <a href="http://moodle.org/sites">{$a->countrycount} países</a> (disponemos de <a href="http://moodle.org/stats">más estadísticas</a>).';
$string['conferencecenter'] = 'Centro de Conferencias de Moodle';
$string['connectedsites'] = 'Algunos sitios Moodle han sido conectados con moodle.org usando la Red Moodle (Moodle Networking), de manera que puede acceder a dichos sitios directamente una vez que se ha identificado aquí.';
$string['connectedsitestitle'] = 'Sitios conectados';
$string['contactbugs'] = 'Puede informar de problemas en el programa Moodle o en cualquier sitio de moodle.org creando una nueva entrada en el Moodle Tracker.';
$string['contactbugstitle'] = 'Informar de errores';
$string['contactintro'] = 'Por favor, escoja entre las siguientes opciones de contacto:';
$string['contactlogin'] = 'Para otras consultas, acceda a este sitio y use el formulario de contacto que aparecerá en esta página.';
$string['contactmoodlecom'] = 'Para cualquier consulta relativa a la licencia, marca comercial o asuntos comerciales, así como grandes desarrollos sobre Moodle, por favor contactar con el servicio de ayuda en <a href="http://moodle.com/">Moodle.com</a>';
$string['contactmoodlecomhelpdesk'] = 'Servicio de ayuda de Moodle.com';
$string['contactmoodlecomtitle'] = 'Moodle.com';
$string['contactmoodleorgemail'] = 'Si tiene problemas con la confirmación de su cuenta en moodle.org, enviar un correo electrónico a esta dirección:';
$string['contactmoodleorglogin'] = 'Entrar a este sitio ahora';
$string['contactmoodleorgother'] = 'Para otro tipo de consultas, utilice el formulario de contacto situado en la parte inferior de la página.';
$string['contactmoodleorgtitle'] = 'Moodle.org';
$string['contactsecurity'] = 'También puede informar de cuestiones de seguridad mediante el Tracker, siempre que el nivel de seguridad configurado sea adecuado.';
$string['contactsent'] = 'Su mensaje se envió por correo electrónico al Gestor de la Comunidad Moodle.';
$string['contactsupport'] = 'Si desea obtener soporte para utilizar Moodle, por favor visite la página de Soporte donde encontrará disponibles muchos recursos de ayuda.';
$string['contactsupporttitle'] = 'Soporte';
$string['developercontributors'] = 'Créditos';
$string['developerlist'] = 'Listado completo de desarrolladores con acceso de escritura';
$string['developermeetings'] = 'Encuentros de desarrolladores';
$string['developers'] = 'El desarrollo principal de Moodle lo lidera el equipo de Moodle.com, ayudado por cientos de desarrolladores en todo el mundo.  Muchos de esos desarrolladores son también responsables directos de diferentes módulos y extensiones.';
$string['developerstitle'] = 'Desarrolladores';
$string['developmentdocs'] = 'La mayor parte de nuestra documentación está en Moodle Docs - incluyendo especificaciones, lluvia de ideas, procedimientos,  estándares y guías de usuario.';
$string['developmentdocstitle'] = 'Documentación de desarrolladores';
$string['developmentintro'] = 'Moodle se plantea como un proceso de desarrollo abierto y transparente que invita a toda la comunidad de usuarios a participar. Naturalmente damos la bienvenida a desarrolladores en PHP pero también puede contribuir mediante los debates en los foros, probando la aplicación, dándonos su opinión y documentando.';
$string['developmenttracker'] = 'Todos los temas sobre desarrollo, fallos, mejoras y nuevas funcionalidades las registramos en el Trakcer de Moodle. Puede ver quién está trabajando y contribuir a las conversaciones. Si está buscando algo sobre un tema específico, debería mirar en primer lugar en el tracker y, por favor, no olvide <strong>votar</strong> en los temas que le gustaría ver resueltos lo antes posible: su voto determina las prioridades a la hora de resolver los temas.';
$string['donations'] = 'Moodle está completamente libre de obligaciones económicas, no obstante muchos miembros de la comunidad han realizado donaciones para ayudar a los desarrolladores que hacen Moodle posible.';
$string['donationsmoney'] = 'Puede contribuir con dinero directamente al fondo a través de una donación en efectivo. Todo este dinero se utiliza para convertir en realidad  los deseos de nuestra hoja de ruta y que todos podamos disfrutarlos. Para hacer una donación con tarjeta de crédito en la mayoría de las principales monedas, por favor haga clic en el botón inferior de Paypal. <br /> <br /> Los donantes de más de $10 añadirán su nombre a esta página durante un año. Por favor, recuerde pulsar el botón "Continuar" después de pagar para ver el formulario donde podrá editar la manera en que  referencia aparecerá, ';
$string['donationsservices'] = 'Si usted tiene necesidad de servicios de Moodle, tales como como hosting, soporte, instalación, programación personalizada, desarrollo de cursos o asesoría, por favor contacte con su distribuidor autorizado <a href="http://moodle.com/"> Moodle Partner de moodle.com </ a> (puede encontrar sus anuncios publicitarios en este sitio). Los socios aportan un porcentaje fijo de todos sus ingresos para el fondo fiduciario de desarrollo de Moodle, por lo que todo el mundo gana.';
$string['donationstitle'] = 'Donaciones';
$string['donationstrust'] = 'Moodle tiene un fondo de desarrollo mantenido por el Moodle Trust, que contrata a programadores para trabajar en Moodle, y sufraga asimismo gastos como moodle.org';
$string['downloadcore'] = 'Nuestro principal método de distribución es a través de estos paquetes estándar con la distribución base. Contienen un conjunto de módulos que son mantenidos por los desarrolladores de Moodle, y son adecuados para ser utilizados en cualquier plataforma donde tenga instalados PHP y una base de datos.';
$string['downloadcoretitle'] = 'Paquetes estándar de Moodle';
$string['downloadcvs'] = 'Otra forma de obtener el código fuente es utilizar directamente CVS para conectar directamente con alguno de los servidores que utilizan los desarrolladores de Moodle.  Esto facilita el proceso de actualización, incluso si ha hecho cambios en el código fuente de su sitio Moodle.';
$string['downloadcvstitle'] = 'Moodle mediante CVS';
$string['downloadintro'] = 'Moodle es código abierto bajo <a href="http://docs.moodle.org/dev/License">GPL licence</a>.  Todo lo que creamos se puede descargar y utilizar gratuita y libremente.';
$string['downloadlang'] = 'En las versiones actuales de Moodle se ha automatizado la adición de paquetes de idiomas desde el menú de administración del sitio. De todas formas, para versiones antiguas de Moodle, los paquetes de idioma se pueden descargar de forma manual.';
$string['downloadlangtitle'] = 'Paquetes de idioma';
$string['downloadlogotitle'] = 'Logos de Moodle';
$string['downloadmac'] = 'Si aún no dispone de un servidor web, estos paquetes con todo incluido le ayudarán a instalar de forma fácil Moodle en cualquier ordenador con Mac OS X.';
$string['downloadmactitle'] = 'Moodle para Mac OS X';
$string['downloadmodules'] = 'Navegue por nuestra base de datos de módulos extra y extensiones que pueden ser instalados en su sitio Moodle para dotarlo de funcionalidades extras más allá de las incluidas en la distribución base de Moodle.';
$string['downloadmodulestitle'] = 'Módulos y extensiones';
$string['downloadthemes'] = 'El aspecto visual de Moodle puede cambiar notablemente en función del tema gráfico.  Mantenemos una base de datos de temas creados y mantenidos por usuarios de Moodle.';
$string['downloadthemestitle'] = 'Temas';
$string['downloadwin'] = 'Si aún no dispone de un servidor web, estos paquetes con todo incluido le ayudarán a instalar de forma fácil Moodle en cualquier ordenador con Microsoft Windows.';
$string['downloadwintitle'] = 'Moodle para Windows';
$string['erroradminonly'] = 'Únicamente los administradores pueden acceder a esta interfaz.';
$string['erroralreadyvoted'] = 'Usted ya ha votado por {$a}';
$string['errormaxmessages'] = 'Lo sentimos, pero no puede enviar más de 3 mensajes.';
$string['errornomainnews'] = 'No se ha podido encontrar o crear un foro principal de noticias en el sitio';
$string['errorsendingmail'] = 'Ha ocurrido un error al enviar el mensaje. Por favor, inténtelo de nuevo más tarde, o contacte con el administrador del sitio.';
$string['events'] = 'Aunque estamos especializados en la enseñanza en línea, siempre es bueno verse todos juntos en persona. Visite estos enlaces para más información sobre nuestras conferencias (las llamamos MoodleMoots) y otros eventos.';
$string['eventstitle'] = 'Eventos';
$string['frontpagewelcome1'] = 'Moodle es un Sistema de Gestión de Cursos de Código Abierto (<i>Open Source Course Management System, CMS</i>), conocido también como Sistema de Gestión del Aprendizaje (<i>Learning Management System, LMS</i>) o como Entorno de Aprendizaje Virtual (<i>Virtual Learning Environment, VLE</i>).  Es una aplicación web gratuita que los educadores pueden utilizar para crear sitios de aprendizaje efectivo en línea.';
$string['frontpagewelcome2'] = 'Moodle.org es el sitio de nuestra comunidad donde se crea y discute Moodle. Por favor, utilice los menús para explorarla y unirse a ella.';
$string['frontpagewelcometitle'] = '¡Bienvenido a la comunidad Moodle!';
$string['generaldeveloperforum'] = 'Foro general de desarrolladores';
$string['graphpopulation'] = 'Gráfico de la población de Moodle';
$string['graphregistrationmap'] = 'Mapa de registros de Moodle';
$string['graphregistrationmapdesc'] = 'Los 10 primeros entre los sitios registrados en {$a} países';
$string['graphusersites'] = 'Comparación de usuarios de Moodle v sitio';
$string['jobs'] = 'Visite nuestra base de datos de trabajo para encontrar puestos de trabajo relacionados con Moodle en todo el mundo.';
$string['jobstitle'] = 'Trabajo en Moodle';
$string['moodlecertification'] = 'Certificación de Moodle';
$string['moodleconsulting'] = 'Consultoría de Moodle';
$string['moodlecourseware'] = 'Cursos de Moodle';
$string['moodlecustomisation'] = 'Personalización de Moodle';
$string['moodledocs'] = 'Documentación de Moodle';
$string['moodlehosting'] = 'Alojamiento de Moodle';
$string['moodleinstallation'] = 'Instalación de Moodle';
$string['moodleintegrations'] = 'Integraciones con Moodle';
$string['moodlesupport'] = 'Soporte de Moodle';
$string['moodlethemes'] = 'Temas gráficos de Moodle';
$string['moodletrackertitle'] = 'Moodle Tracker';
$string['moodletraining'] = 'Formación en Moodle';
$string['mycoursesintro'] = 'Actualmente está matriculado en los siguientes "cursos" en este sitio de la comunidad, cada uno de ellos podría disponer de uno o más foros.';
$string['nameabout'] = 'Acerca de';
$string['nameaboutmoodle'] = 'Acerca de Moodle';
$string['namecommercial'] = 'Servicios comerciales';
$string['namecommunity'] = 'Comunidad';
$string['namecontact'] = 'Contacto';
$string['namedevelopment'] = 'Desarrollo';
$string['namedocumentation'] = 'Documentación';
$string['namedownloads'] = 'Descargas';
$string['nameevents'] = 'Eventos';
$string['nameforums'] = 'Foros';
$string['namemycourses'] = 'Mis cursos';
$string['namenetwork'] = 'Sitios conectados';
$string['namenews'] = 'Noticias';
$string['namesecurity'] = 'Avisos de seguridad';
$string['namesupport'] = 'Soporte';
$string['networkintro'] = 'Los sitios Moodle que figuran a continuación han sido conectados con moodle.org utilizando la Red Moodle, de manera que puede entrar a ellos directamente desde aquí.';
$string['newregistrations'] = 'Nuevos registros';
$string['newsbuzz'] = 'Se habla de Moodle';
$string['newsbuzzdetail'] = 'Publicaciones relacionadas con Moodle de todo el mundo';
$string['newscalendar'] = 'Calendario';
$string['newscalendardetail'] = 'Eventos relacionados con Moodle en el futuro';
$string['newsofficial'] = 'Noticias oficiales sobre Moodle';
$string['newsplanet'] = 'Planeta Moodle';
$string['newsplanetdetail'] = 'Blogs sindicados de los desarrolladores de Moodle';
$string['newsrecent'] = 'Noticias recientes';
$string['newssecurity'] = 'Avisos de seguridad';
$string['newssecuritydetail'] = 'Información importante sobre cuestiones de seguridad';
$string['noenrolledcoursesyet'] = 'Aún no se ha matriculado en ningún curso de este sitio';
$string['overviewabout'] = 'Descripción general sobre Moodle';
$string['overviewcommunity'] = 'Una descripción general de la comunidad Moodle';
$string['overviewdevelopment'] = 'Una descripción general sobre desarrollo en Moodle';
$string['overviewdownloads'] = 'Una descripción general de las descargas de Moodle';
$string['overviewmy'] = 'Ver todos los cursos de moodle.org donde está matriculado';
$string['overviewnews'] = 'Una descripción general de las noticias de Moodle';
$string['overviewsupport'] = 'Una descripción general de las opciones de soporte de Moodle';
$string['popularissues'] = 'Temas más populares';
$string['recentpart'] = 'Esta página muestra algunas de las personas que están utilizando moodle.org hoy.';
$string['recentparttitle'] = 'Participantes recientes';
$string['registeredsites'] = 'Las instituciones no están obligadas a informar a nadie cuando usan Moodle, porque Moodle es Código Abierto.  Aún así, algunos sitios Moodle han escogido registrarse con nosotros y así los podemos listar.';
$string['registeredsitestitle'] = 'Sitios registrados';
$string['registereduserslastday'] = 'Usuarios nuevos en las últimas 24 horas';
$string['registereduserstotal'] = 'Total de usuarios registrados:';
$string['registrationgraphalt'] = 'Registros totales en Moodle a lo largo del tiempo';
$string['registrationgraphdesc'] = 'Llevamos a cabo una <a href="http://docs.moodle.org/en/Usage">comprobación masiva regular de los sitios </a> para asegurarnos de que aún existen, por lo que en ocasiones es posible que vea reducciones en el recuento';
$string['registrationslast6months'] = 'Registros en los últimos 6 meses';
$string['registrationstotal'] = 'Todos los registros actuales';
$string['roadmap'] = 'Hoja de ruta de Moodle';
$string['shop'] = '¿Busca la forma de hacer ver que forma parte de nuestra comunidad? Eche un ojo a nuestra tienda donde encontrará camisetas, tazas y otras cosas.';
$string['shoptitle'] = 'Tienda de Moodle';
$string['sourcecodetitle'] = 'Código Abierto';
$string['statscountries'] = 'Países';
$string['statscourses'] = 'Cursos';
$string['statsenrolments'] = 'Matriculaciones';
$string['statsposts'] = 'Mensajes en foros';
$string['statsquestions'] = 'Preguntas de cuestionario';
$string['statsresources'] = 'Recursos';
$string['statsteachers'] = 'Profesores';
$string['statsusers'] = 'Usuarios';
$string['supportbooks'] = 'Mantenemos una lista de libros a la venta sobre Moodle.';
$string['supportbookstitle'] = 'Libros y manuales';
$string['supportcommercial'] = 'Los <a href="http://moodle.com/">Partners de Moodle</a> son un grupo de empresas que prestan servicios autorizados por todo el mundo encargados de financiar económicamente el proyecto de código abierto Moodle. Proporcionan una gran variedad de servicios comerciales para los usuarios de Moodle en todo el mundo:';
$string['supportcommercialtitle'] = 'Servicios comerciales';
$string['supportdocs1'] = 'La documentación de Moodle es un buen sitio para empezar, sobre todo nuestra página de Preguntas Frecuentes.';
$string['supportdocs2'] = 'Una buena manera de acceder a documentación relevante de Moodle es utilizar el enlace "Documentación de Moodle para esta página" en la parte inferior de cada página de su sitio Moodle.';
$string['supportdocsfaq'] = 'Preguntas frecuentes';
$string['supportdocslang'] = 'Documentación de Moodle en otros idiomas';
$string['supportdocstitle'] = 'Documentación';
$string['supportforums'] = 'Nuestra comunidad de usuarios se comunica principalmente mediante los foros dentro de los "cursos" de este sitio Moodle.  Debe "matricularte" en el curso para poder enviar mensajes (la matriculación es totalmente gratuita).';
$string['supportforumsenglish'] = 'Aquí la mayoría del soporte y debates entre usuarios y desarrolladores están en inglés:';
$string['supportforumsenglishname'] = 'Usando Moodle';
$string['supportforumslang'] = 'El foro de Moodle para hacer vida social en inglés está aquí:';
$string['supportforumslangname'] = 'Sala de estar de Moodle';
$string['supportforumslangurl'] = 'http://moodle.org/course/view.php?id=55';
$string['supportforumslist'] = 'También disponemos de otros foros, en muchos idiomas:';
$string['supportforumslistname'] = 'Listado de todos los foros';
$string['supportforumstitle'] = 'Foros';
$string['supportintro'] = '¡No está solo!  Hay muchas formas de conseguir ayuda con Moodle si lo necesita.';
$string['top10sitesbycourses'] = 'Los 10 sitios con más cursos';
$string['top10sitesbyusers'] = 'Los 10 sitios con más usuarios';
